% This class file is used for making manuscripts for cems journal.
%   Ver 1.00 2021/04/30
%   Ver 1.01 2021/12/25 Mathematical Subject -> Mathematics Subject
%   Ver 1.02 2022/03/15 change the textheight, textwidith and oddsidemargin, proof environment.
% by Hidetoshi Komiya (hkomiya@keio.jp)
%
\ProvidesClass{cems-submit}[2021/03/14]
%
\LoadClass[a4paper]{article}

\usepackage{amsmath, amssymb}
\usepackage{amsthm}

\theoremstyle{plain}
\newtheorem{theorem}{Theorem}
\newtheorem{proposition}{Proposition}
\newtheorem{corollary}{Corollary}
\newtheorem{lemma}{Lemma}

\theoremstyle{definition}
\newtheorem{definition}{Definition}
\newtheorem{remark}{Remark}
\newtheorem{example}{Example}
\newtheorem{axiom}{Axiom}

\addtolength{\oddsidemargin}{-18.5truemm}
\addtolength{\textwidth}{38truemm}
\addtolength{\textheight}{5truemm}
%\addtolength{\textheight}{15truemm} % 原論文用
%
%
%   Double Space Setting
%
\def\baselinestretch{1.5}
%
% Title Page Setting
% maketitle parameters: title, author, affiliation, correspondence
%
  \def\@maketitle{%
  \newpage
  \null
  \vskip -6em
  {\noindent Submitted to\\
  \it Communications in Economics and Mathematical Sciences}
  \vskip 4em%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE\bf \@title \par}%
    \vskip 2.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
  \end{center}%
  \par
    \begin{center}
      {\bf correspondence to \vspace{-.5em}\vspace{0pt}}
      \@correspondence
    \end{center}
    \begin{center}
      {\bf Date of submission:\vspace{-.5em}\vspace{0pt}}
      \@date
    \end{center}
  \vskip 3.5em
    \begin{center}
      {\bf Abstract}
      \begin{quotation}
      \@abstract
      \end{quotation}
    \end{center}
    \par
  \vskip 3.5em
    \noindent
        {\bf Keywords:}  \@keywords \\
        {\bf Journal of Economic Literature Classification:}  \@JEL \\
        {\bf 2020 Mathematics Subject Classification:}  \@MSC
    \vskip 1.5em


    \gdef\@correspondence{}
    \gdef\@abstract{}
%    \gdef\@norevision{}
%    \gdef\@submission{}
%    \gdef\@revison{}
%    \gdef\@acceptance{}
    \gdef\@keywords{}
    \gdef\@JEL{}
    \gdef\@MSC{}
    \gdef\@affiliation{}
  }

  \long\def\abstract#1{\long\gdef\@abstract{#1}}
  \long\def\correspondence#1{\long\gdef\@correspondence{#1}}
  \long\def\keywords#1{\long\gdef\@keywords{#1}}
  \long\def\JEL#1{\long\gdef\@JEL{#1}}
  \long\def\MSC#1{\long\gdef\@MSC{#1}}

  \long\def\affiliation#1{\long\gdef\@affiliation{#1}}

%  \long\def\norevision#1{\long\gdef\@norevision{#1}}
%  \long\def\submission#1{\long\gdef\@submission{#1}}
%  \long\def\revision#1{\long\gdef\@revision{#1}}
%  \long\def\acceptance#1{\long\gdef\@acceptance{#1}}

\makeatletter
\renewenvironment{proof}[1][\proofname]{\par
  \pushQED{\qed}%
  \normalfont \topsep6\p@\@plus6\p@\relax
  \trivlist
  \item\relax
        {\bf%\itshape イタリックをボールドに変更
    #1\@addpunct{.}}\hspace\labelsep\ignorespaces
}{%
  \popQED\endtrivlist\@endpefalse
}
\makeatother

% End of cems-submit.cls
